/*
 * linflexd_uart.c
 *
 *  Created on: Mar 2, 2016
 *      Author: B55457
 */



#include "linflexd_uart.h"

unsigned char UARTFirstTransmitFlag_0;
unsigned char UARTFirstTransmitFlag_1;
/*****************************************************************************/
/*
** Baud Rate = LINCLK / (16 x LFDIV)
** LINCLK = BR x (16 x LFDIV)
** LINCLK / (BR x 16) = LFDIV
**
** LFDIV = Mantissa.Fraction.
** Mantissa = LINIBRR
** Fraction = LINFBRR / 16
**
** Baud Rate = LINCLK / (16 x LINIBRR.(LINFBRR / 16))
** LINIBRR.(LINFBRR / 16) = LINCLK / (BR x 16)
** LINIBRR = Mantissa[LINCLK / (BR x 16)]
** Remainder =  LINFBRR / 16
** LINFBRR = Remainder * 16
** The Remainder is < 1, So how does the Remainder work during a divide?
** May be best to use a table?
**
** For Refernce & Quick Tests
** LINFLEX_x.LINIBRR.R = 416;                   // 9600 at 64MHz
** LINFLEX_x.LINFBRR.R = 11;
**
** LINFLEX_x.LINIBRR.R = 781;                   // 9600 at 120MHz
** LINFLEX_x.LINFBRR.R = 4;
*/
/*****************************************************************************/

void initLINFlexD_1 ( unsigned int MegaHertz, unsigned int BaudRate ) {
  unsigned int Fraction;
  unsigned int Integer;

  LINFlexD_1.LINCR1.B.INIT = 1;     /* Enter Initialization Mode */
  LINFlexD_1.LINCR1.B.SLEEP = 0;    /* Exit Sleep Mode */
  LINFlexD_1.UARTCR.B.UART = 1;     /* UART Enable- Req'd before UART config.*/
  LINFlexD_1.UARTCR.R = 0x0033;     /* UART Ena, 1 byte tx, no parity, 8 data*/
  LINFlexD_1.UARTSR.B.SZF = 1;      /* CHANGE THIS LINE   Clear the Zero status bit */
  LINFlexD_1.UARTSR.B.DRFRFE = 1;   /* CHANGE THIS LINE  Clear DRFRFE flag - W1C */

  BaudRate  = (MegaHertz * 1000000) / BaudRate;
  Integer   = BaudRate / 16;
  Fraction  = BaudRate - (Integer * 16);

  LINFlexD_1.LINIBRR.R = Integer;
  LINFlexD_1.LINFBRR.R = Fraction;

  LINFlexD_1.LINCR1.B.INIT = 0;     /* Exit Initialization Mode */

  UARTFirstTransmitFlag_1 = 1;        /* Indicate no Tx has taken place yet */

  /* Configure LINFlexD_1 TxD Pin. */
  SIUL2.MSCR[59].B.SSS = 2; //Pad PD11: Set to LINFlex_1 TxD
  SIUL2.MSCR[59].B.OBE = 1; //Enable output buffer
  SIUL2.MSCR[59].B.SRC = 3; //Full drive-strength without slew rate control

  /* Configure LINFlexD_1 RxD Pin. */
  SIUL2.MSCR[95].B.IBE = 1; //Pad PF15: Enable input buffer
  SIUL2.IMCR[63].B.SSS = 0b0011; //Connect LINFlexD_1 signal to PF15
}
/*****************************************************************************/

char message_1[] = {"\n\rThis is the S32R274RRUEVB UART test.  If you see this in your PC terminal, test was successful.\n\r"};

void testLINFlexD_1( void )  {     /* Display message to terminal */

	int i, size;
	  size = sizeof(message_1);
	  /* Send to LINFlex_1. */
	  for (i = 0; i < size; i++) {
	    txLINFlexD_1(message_1[i]); //Send from LINFlex_1
	  }
}
/*****************************************************************************/

unsigned char rxLINFlexD_1() {
  while (LINFlexD_1.UARTSR.B.DRFRFE == 0); /* Wait for dta reception complete*/
  LINFlexD_1.UARTSR.R &= UART_DRFRFE;      /* Clear data receptoin flag W1C */
  return( LINFlexD_1.BDRM.B.DATA4 );       /* Read byte of Data */
}
/*****************************************************************************/

void txLINFlexD_1( unsigned char Data ) {
  if( UARTFirstTransmitFlag_1 )   {         /* 1st byte transmit after init: */
    UARTFirstTransmitFlag_1 = 0;            /* Clear variable */
  }
  else {                                  /* Normal tranmit (not 1st time): */
    while (LINFlexD_1.UARTSR.B.DTFTFF == 0); /* Wait for data trans complete*/
    LINFlexD_1.UARTSR.R &= UART_DTFTFF;      /* Clear DTFTFF flag - W1C */
  }
  LINFlexD_1.BDRL.B.DATA0 = Data;            /* Transmit 8 bits Data */
}
/*****************************************************************************/

unsigned char checkLINFlexD_1()  {      /* Optional utility for status check */
  return( LINFlexD_1.UARTSR.B.DRFRFE ); /* Return Receive Buffer Status */
}
/*****************************************************************************/

void echoLINFlexD_1() {                 /* Optional utility to echo char. */
  txLINFlexD_1( rxLINFlexD_1() );
}
/*****************************************************************************/
